/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.ccfw.pa.system;

import com.ibm.hsc.ccfw.pa.system.PIBpa;
import com.ibm.hsc.ccfw.pa.system.PIFsp;
import com.ibm.hsc.ccfw.pa.system.PIMachineSystem;
import com.ibm.hsc.common.util.PIHscUtil;
import com.ibm.hwmca.base.pa.ar.XMLHelper;
import com.ibm.hwmca.fw.XMLEncodeable;
import com.ibm.hwmca.fw.managed.ManagedObject;
import com.ibm.hwmca.fw.persist.PersistenceException;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.system.RemoteSystemManager;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.UnsignedInt16;
import org.w3c.dom.Node;

public class PIBpcFsp
extends PIFsp {
    private static final String TRACE_MASKT = "PPABPCFT";
    private static final String TRACE_MASKF = "PPABPCFF";
    private static final String TRACE_MASKD = "PPABPCFD";
    public PIBpcFspPersistentData pibfPD;
    private transient PIBpa encapsulatingBpa;
    private transient Object dataLock = null;

    public PIBpcFsp() {
        Trace.trace((String)TRACE_MASKT, (Object)("<->PIBpcFsp::ctor() Object id: " + this.getObjectString()));
        this.initPersistentData();
    }

    public PIBpcFsp(String string, String string2, String string3) {
        super(string, string2, string3);
        Trace.trace((String)TRACE_MASKT, (Object)("<->PIBpcFsp::ctor(mt,mm,ms) Object id: " + this.getObjectString()));
        this.initPersistentData();
    }

    public PIBpcFsp(CIMInstance cIMInstance, boolean bl) {
        super(cIMInstance, bl);
        Trace.trace((String)TRACE_MASKT, (Object)("<->PIBpcFsp::ctor(cimInstance, parseInstance) Object id: " + this.getObjectString()));
        if (this.pibfPD == null) {
            this.initPersistentData();
        }
    }

    public PIBpcFsp(PersistentData persistentData) throws PersistenceException {
        super(((PIBpcFspPersistentData)persistentData).superData);
        Trace.trace((String)TRACE_MASKT, (Object)("<->PIBpcFsp::ctor(PersistentData) Object id: " + this.getObjectString()));
        this.initPersistentData();
        this.setLocationCode(((PIBpcFspPersistentData)persistentData).locationCode);
        this.setLastLogEntryID(((PIBpcFspPersistentData)persistentData).lastLeid);
        this.associateEncapsulatingBpa();
        Trace.trace((String)TRACE_MASKD, (Object)"Rebuilt PIBpcFsp [");
        Trace.trace((String)TRACE_MASKD, (Object)("locationCode=" + this.getLocationCode()));
        Trace.trace((String)TRACE_MASKD, (Object)("lastLeid=" + Long.toString(this.getLastLogEntryID(), 16)));
        Trace.trace((String)TRACE_MASKD, (Object)"]");
    }

    private void initPersistentData() {
        this.pibfPD = new PIBpcFspPersistentData();
        this.pibfPD.superData = super.getPersistentData();
    }

    public PersistentData getPersistentData() {
        if (this.pibfPD.superData == null) {
            this.pibfPD.superData = super.getPersistentData();
        }
        return this.pibfPD;
    }

    public String getCIMClass() {
        return "IBMHSC_Connection";
    }

    public void setCIMInstance(CIMInstance cIMInstance) {
        super.setCIMInstance(cIMInstance);
        if (this.getEncapsulatingBpa() != null) {
            this.setMOID(this.getEncapsulatingBpa().getMOID());
        }
    }

    protected void parseCIMInstance() {
        if (this.pibfPD == null) {
            this.initPersistentData();
        }
        try {
            this.setLocationCode((String)PIHscUtil.getCIMAttribute(this.getCIMInstance(), "LocationCode").getValue());
            Trace.trace((String)TRACE_MASKD, (Object)("LocationCode=" + this.getLocationCode()));
        }
        catch (Exception exception) {
            Trace.trace((String)TRACE_MASKT, (Object)"Exception caught obtaining CIM 'LocationCode' attribute");
            Trace.trace((String)TRACE_MASKT, (Object)exception);
        }
        try {
            String string = (String)PIHscUtil.getCIMAttribute(this.getCIMInstance(), "SystemName").getValue();
            Trace.trace((String)TRACE_MASKD, (Object)("frameMTMS=" + string));
            this.setMachineType(string.substring(0, string.indexOf("-")));
            this.setMachineModel(string.substring(string.indexOf("-") + 1, string.indexOf("*")));
            this.setMachineSerial(string.substring(string.indexOf("*") + 1));
            this.setSystemName(this.getMTMS() + ":" + this.getLocationCode());
        }
        catch (Exception exception) {
            Trace.trace((String)TRACE_MASKT, (Object)"Exception obtaining MTMS - making 0-0/0");
            Trace.trace((String)TRACE_MASKT, (Object)exception);
            this.setMachineType("0");
            this.setMachineModel("0");
            this.setMachineSerial("0");
            this.setSystemName(this.getMTMS() + ":" + this.getLocationCode());
        }
        if (this.isDummy()) {
            Trace.trace((String)TRACE_MASKF, (Object)"Halting CIMInstance processing - dummy instance");
        }
        this.associateEncapsulatingBpa();
    }

    public boolean isDummy() {
        return this.getSystemName().startsWith("0-0");
    }

    public void associateEncapsulatingBpa() {
        Trace.trace((String)TRACE_MASKT, (Object)("--> associateEncapsulatingBpa() with this BPC " + this.getObjectString()));
        PIBpa pIBpa = new PIBpa();
        RemoteSystemManager remoteSystemManager = RemoteSystemManager.getRemoteSystemManager();
        if (remoteSystemManager != null) {
            this.associateEncapsulatingBpa(remoteSystemManager.getKnownSystems(((Object)((Object)pIBpa)).getClass()));
        } else {
            Trace.trace((String)TRACE_MASKD, (Object)"<-> associateEncapsulatingBpa: No RemoteSystemManager - can't associate PIBpa yet");
        }
        if (this.getEncapsulatingBpa() == null) {
            Trace.trace((String)TRACE_MASKF, (Object)"<-> associateEncapsulatingBpa: No PIBpa associated with PIBpcFsp - error?");
        }
    }

    public void associateEncapsulatingBpa(Set set) {
        Trace.trace((String)TRACE_MASKT, (Object)("--> associateEncapsulatingBpa(bpaSet) with this BPC " + this.getObjectString()));
        if (set == null || set.size() == 0) {
            Trace.trace((String)TRACE_MASKD, (Object)"<-> associateEncapsulatingBpa: empty BPA set");
            return;
        }
        PIBpa pIBpa = null;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            pIBpa = (PIBpa)((Object)iterator.next());
            if (!pIBpa.getMTMS().equals(this.getMTMS())) continue;
            Trace.trace((String)TRACE_MASKF, (Object)("associating BPC [" + this.getUniqueCIMKey() + " with BPA [" + pIBpa.getUniqueCIMKey() + "]"));
            Trace.trace((String)TRACE_MASKF, (Object)("      BPC " + this.getObjectString() + " with BPA " + pIBpa.getObjectString()));
            this.setEncapsulatingBpa(pIBpa);
            pIBpa.addBpc(this);
            return;
        }
    }

    public void disassociateEncapsulatingBpa() {
        PIBpa pIBpa = this.getEncapsulatingBpa();
        if (pIBpa != null) {
            Trace.trace((String)TRACE_MASKT, (Object)("disassociating BPC [" + this.getUniqueCIMKey() + " with BPA [" + pIBpa.getUniqueCIMKey() + "]"));
            pIBpa.removeBpc(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocationCode(String string) {
        if (this.dataLock == null) {
            this.dataLock = new Object();
        }
        Object object = this.dataLock;
        synchronized (object) {
            this.pibfPD.locationCode = string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLocationCode() {
        if (this.dataLock == null) {
            this.dataLock = new Object();
        }
        Object object = this.dataLock;
        synchronized (object) {
            if (this.pibfPD == null || this.pibfPD.locationCode == null) {
                return "";
            }
            return this.pibfPD.locationCode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastLogEntryID(long l) {
        if (this.dataLock == null) {
            this.dataLock = new Object();
        }
        Object object = this.dataLock;
        synchronized (object) {
            this.pibfPD.lastLeid = l;
            this.pibfPD.sLastLeid = Long.toString(l, 16);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastLogEntryID() {
        if (this.dataLock == null) {
            this.dataLock = new Object();
        }
        Object object = this.dataLock;
        synchronized (object) {
            return this.pibfPD.lastLeid;
        }
    }

    public String getUniqueCIMKey() {
        return this.getCIMClass() + ":" + this.getMTMS() + ":" + this.getLocationCode();
    }

    public boolean canCommunicate() {
        if (this.getCIMInstance() == null) {
            Trace.trace((String)TRACE_MASKF, (Object)"PIBpcFsp::canCommunicate() returning false; null CIMInstance");
            return false;
        }
        int n = 0;
        try {
            n = ((UnsignedInt16)PIHscUtil.getCIMAttribute(this.getCIMInstance(), "ConnectionState").getValue()).intValue();
        }
        catch (Exception exception) {
            Trace.trace((String)TRACE_MASKT, (Object)this.getSystemTrace("Exception obtaining 'ConnectionState' attribute"));
            Trace.trace((String)TRACE_MASKT, (Object)exception);
            Trace.trace((String)TRACE_MASKF, (Object)"PIBpcFsp::canCommunicate() returning false; exception obtaining state");
            return false;
        }
        Trace.trace((String)TRACE_MASKF, (Object)("PIBpcFsp::canCommunicate() sysState is " + n + " returning " + (n == 0)));
        return n == 0;
    }

    public void setEncapsulatingBpa(PIBpa pIBpa) {
        Trace.trace((String)TRACE_MASKT, (Object)("<-->PIBpcFsp::setEncapsulatingBpa() setting to " + pIBpa.getUniqueCIMKey()));
        Trace.trace((String)TRACE_MASKT, (Object)("BSP BPC:" + this.getObjectString()));
        Trace.trace((String)TRACE_MASKT, (Object)("BSP BPA:" + pIBpa.getObjectString()));
        this.encapsulatingBpa = pIBpa;
    }

    public PIBpa getEncapsulatingBpa() {
        return this.encapsulatingBpa;
    }

    public CIMObjectPath getFSPObjectPath() {
        Trace.trace((String)TRACE_MASKT, (Object)"-->PIBpcFsp::getFSPObjectPath()");
        Trace.trace((String)TRACE_MASKT, (Object)("BSP BPC:" + this.getObjectString()));
        if (this.getEncapsulatingBpa() == null) {
            Trace.trace((String)TRACE_MASKT, (Object)"BSP null BPA");
        } else {
            Trace.trace((String)TRACE_MASKT, (Object)("BSP BPA:" + this.getEncapsulatingBpa().getObjectString()));
            if (this.getEncapsulatingBpa().getCIMObjectPath() == null) {
                Trace.trace((String)TRACE_MASKT, (Object)"BSP null BPA path");
            } else {
                Trace.trace((String)TRACE_MASKT, (Object)("BSP BPA path:" + this.getEncapsulatingBpa().getCIMObjectPath()));
            }
        }
        if (this.getEncapsulatingBpa() != null) {
            Trace.trace((String)TRACE_MASKT, (Object)("<--PIBpcFsp::getFSPObjectPath() returning " + this.getEncapsulatingBpa().getCIMObjectPath()));
            return this.getEncapsulatingBpa().getCIMObjectPath();
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<--PIBpcFsp::getFSPObjectPath() returning null");
        return null;
    }

    public static Enumeration getLiveSystems(int n) throws Exception {
        Vector<PIBpcFsp> vector;
        block10: {
            Trace.trace((String)TRACE_MASKD, (Object)"--> getLiveSystems");
            vector = new Vector<PIBpcFsp>();
            try {
                String string = new PIBpcFsp().getCIMClass();
                Enumeration enumeration = PIMachineSystem.getCIMInstances(n, string);
                if (enumeration != null && enumeration.hasMoreElements()) {
                    CIMInstance cIMInstance = null;
                    PIBpcFsp pIBpcFsp = null;
                    while (enumeration.hasMoreElements()) {
                        cIMInstance = (CIMInstance)enumeration.nextElement();
                        String string2 = (String)PIHscUtil.getCIMAttribute(cIMInstance, "LocationCode").getValue();
                        if (!string2.equals("SIDE_A") && !string2.equals("SIDE_B")) {
                            Trace.trace((String)TRACE_MASKD, (Object)("Ignoring non-BPC IBMHSC_Connection (locationCode=" + string2 + ")]"));
                            continue;
                        }
                        pIBpcFsp = new PIBpcFsp(cIMInstance, true);
                        if (pIBpcFsp.isDummy()) {
                            Trace.trace((String)TRACE_MASKD, (Object)("Ignoring dummy CIMInstance [" + pIBpcFsp.getSystemName() + "]"));
                            continue;
                        }
                        pIBpcFsp.setCIMRetryTime(n);
                        Trace.trace((String)TRACE_MASKD, (Object)("System key=" + pIBpcFsp.getUniqueCIMKey()));
                        try {
                            Trace.trace((String)TRACE_MASKD, (Object)("System state=" + ((UnsignedInt16)PIHscUtil.getCIMAttribute(pIBpcFsp.getCIMInstance(), "ConnectionState").getValue()).intValue()));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        vector.add(pIBpcFsp);
                    }
                    break block10;
                }
                if (enumeration == null) {
                    Trace.trace((String)TRACE_MASKT, (Object)"Null enumeration returned by CIM");
                } else {
                    Trace.trace((String)TRACE_MASKD, (Object)("No " + string + " instances returned by CIM"));
                }
            }
            catch (Exception exception) {
                Trace.trace((String)TRACE_MASKT, (Object)"<-- getLiveSystems: Exception caught obtaining systems");
                throw exception;
            }
        }
        Trace.trace((String)TRACE_MASKD, (Object)("<-- getLiveSystems (" + vector.size() + " systems)"));
        return vector.elements();
    }

    public ManagedObject getMO() {
        if (this.getEncapsulatingBpa() == null) {
            return null;
        }
        return this.getEncapsulatingBpa().getMO();
    }

    public String getMOSystemName() {
        if (this.getEncapsulatingBpa() == null) {
            return null;
        }
        return this.getEncapsulatingBpa().getMOSystemName();
    }

    public static class PIBpcFspPersistentData
    implements PersistentData,
    XMLEncodeable {
        private static final long serialVersionUID = 1L;
        public PersistentData superData = null;
        protected String locationCode = "";
        public long lastLeid = 0L;
        protected String sLastLeid = "";

        public void toXML(StringBuffer stringBuffer) {
            stringBuffer.append("<PersistentData class=\"" + this.getClass().getName() + "\"");
            stringBuffer.append(" locationCode=\"" + this.locationCode + "\"");
            stringBuffer.append(" lastLeid=\"" + this.lastLeid + "\"");
            stringBuffer.append("/>");
        }

        public void fromXML(Node node) {
            Node node2 = node.getChildNodes().item(0);
            if (!node2.getNodeName().equals("PersistentData")) {
                Trace.trace((String)PIBpcFsp.TRACE_MASKT, (Object)"<-> PIBpcFspPersistentData.fromXML: necessary 'PersistentData' node not found");
                return;
            }
            this.locationCode = XMLHelper.unconvertQuote((String)XMLHelper.getAttributeValue((Node)node2, (String)"locationCode"));
            this.lastLeid = Long.valueOf(XMLHelper.getAttributeValue((Node)node2, (String)"lastLeid"));
        }
    }
}

